rmvnorm <- function(n, reps, mean = rep(0, nrow(SqrtSigma)), SqrtSigma = NULL){
  stopifnot(is.numeric(SqrtSigma) || is.list(SqrtSigma))
  if(is.numeric(SqrtSigma) && is.vector(SqrtSigma)){
    stopifnot(length(SqrtSigma) %in% c(1, n))
    output <- matrix(rnorm(reps * n, sd = SqrtSigma), ncol = reps)
  } else {
    nc <- if(is.matrix(SqrtSigma)){
      ncol(SqrtSigma)
    } else {
      stopifnot(is.list(SqrtSigma))
      sum(sapply(SqrtSigma, ncol))
    }
    output <- covprod(SqrtSigma, matrix(rnorm(reps * nc), ncol = reps))
  }
  return(output)
}
