# Verify that Y is numeric and has at least two entries.
validate_Y <- function(Y, verbose){
  if(!is.vector(Y)){
    if(isTRUE(verbose)) message("Coercing Y to vector...")
    Y <- tryCatch(as.vector(Y), error = function(e) stop("Error converting Y to a vector: ", e))
  }
  validate_numeric(x = Y, min_len = 2, message = "Y failed numeric validation: ")
  return(Y)
}
