validate_order_columns <- function(data, cols){
  stopifnot(is.list(cols))
  cols <- unlist(cols)
  if(!is.character(cols)){
    stop("Ordering column specification must be a list of character elements.")
  }
  # Verify no NAs.
  stopifnot("Columns for ordering has at least one NA" = all(!is.na(cols)),
            is.character(cols) || is.numeric(cols))
  # Verify that all elements are column names.
  bad_names <- cols[which(!(cols %in% colnames(data)))]
  if(length(bad_names) > 0)
    stop("Ordering columns not found in data: ",
         paste(bad_names, collapse = ", "))
}
