\name{asymptotics}
\alias{asymptotics}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
	Convenience function for exploring asymptotic behavior and sample size adequacy
}
\description{
	This is a convenience function that calls \code{\link{compare}} using \code{object} to create the true and test model specifications.
}
\usage{
	asymptotics(object, ...)

}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{
	Object of class \code{distfreereg}.
}
  \item{...}{
	Additional arguments to pass to \code{\link{compare}}.
}
}

\details{
	An important step in implementing \code{\link{distfreereg}} is determining the plausibility that the sample size of a data set is adequate to produce the desired asymptotic behavior of the simulated statistics. This can be done by calling \code{\link{compare}} with the appropriate argument values. Because of the importance of this step, this convenience function automates that call using a single argument, namely the object of class \code{distfreereg} in question.
}

\section{Warning}{
	The fitted model in \code{object} is assumed to be the true model, not an estimation of the true model. Further, the simulation of values requires assuming a particular error distribution. See the "Warnings" section in \code{\link{compare}}'s documentation for details.
}
\value{
	Object of class \code{compare}.
}
\author{
	Jesse Miller
}

%% ~Make other sections like Warning with \section{Warning }{....} ~
\seealso{
	\code{\link{distfreereg}}, \code{\link{compare}}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory (show via RShowDoc("KEYWORDS")):
% \keyword{ ~kwd1 }
% \keyword{ ~kwd2 }
% Use only one keyword per line.
% For non-standard keywords, use \concept instead of \keyword:
% \concept{ ~cpt1 }
% \concept{ ~cpt2 }
% Use only one concept per line.
