% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_extractors.R
\name{dist_replace}
\alias{dist_replace}
\title{Replacement values in dist}
\usage{
dist_replace(object, i, j, value, k)
}
\arguments{
\item{object}{dist object}

\item{i}{(integer vector) row positions}

\item{j}{(integer vector) column positions}

\item{value}{(integer/numeric vector) Values to replace}

\item{k}{(integer vector) positions}
}
\value{
dist object
}
\description{
Replacement values of a dist object with either ij or
  position indexing
}
\details{
There are two modes to specify the positions:

  \itemize{

  \item ij-mode where i and j are specified and k is missing. If i or j are
  missing, they are interpreted as all values of i or j (similar to matrix or
  dataframe subsetting). Lengths of i, j are required to be same. If 'value'
  is singleton, then it is extended to the length of i or j. Else, 'value'
  should have same length as i or j.

  \item k-mode where  k is present and both i and k are missing. k is the
  positions in the dist object. If 'value' is singleton, then it is extended
  to the length of k. Else, 'value' should have same length as k.

  }
}
\examples{

# create a dist object
d <- dist(iris[,1:4])
attr(d, "Labels") <- outer(letters, letters, paste0)[1:150]
head(d)
max(d)
as.matrix(d)[1:5, 1:5]

# replacement in ij-mode
d <- dist_replace(d, 1, 2, 100)
dist_extract(d, 1, 2, product = "inner")
d <- dist_replace(d, "ca", "ba", 102)
dist_extract(d, "ca", "ba", product = "inner")

d <- dist_replace(d, 1:5, 6:10, 11:15)
dist_extract(d, 1:5, 6:10, product = "inner")
d <- dist_replace(d, c("ca", "da"), c("aa", "ba"), 102)
dist_extract(d, c("ca", "da"), c("aa", "ba"), product = "inner")

# replacement in k-mode
d <- dist_replace(d, k = 2, value = 101)
dist_extract(d, k = 2)
dist_extract(d, 3, 1, product = "inner") # extracting k=2 in ij-mode
}
