% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_studentized_range.R
\name{dist_studentized_range}
\alias{dist_studentized_range}
\title{The Studentized Range distribution}
\usage{
dist_studentized_range(nmeans, df, nranges)
}
\arguments{
\item{nmeans}{sample size for range (same for each group).}

\item{df}{degrees of freedom for \eqn{s} (see below).}

\item{nranges}{number of \emph{groups} whose \bold{maximum} range is
    considered.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Tukey's studentized range distribution, used for Tukey's
honestly significant differences test in ANOVA.
}
\details{
We recommend reading this documentation on
\url{https://pkg.mitchelloharawild.com/distributional/}, where the math
will render nicely.

\strong{Support}: \eqn{R^+}, the set of positive real numbers.

Other properties of Tukey's Studentized Range Distribution
are omitted, largely because the distribution is not fun
to work with.
}
\examples{
dist <- dist_studentized_range(nmeans = c(6, 2), df = c(5, 4), nranges = c(1, 1))

dist

cdf(dist, 4)

quantile(dist, 0.7)

}
\seealso{
\link[stats:Tukey]{stats::Tukey}
}
