% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds_search_all.R
\name{ds_search_all}
\alias{ds_search_all}
\title{ds_search_all}
\usage{
ds_search_all(resource_id, fields = NULL, filters = NULL,
  num_records = NULL, offset = 0, sort = NULL, q = NULL,
  url = get_url(), credentials = list(cookie = dkanr::get_cookie(),
  token = dkanr::get_token()), as = "df")
}
\arguments{
\item{resource_id}{character: DKAN resource ID}

\item{fields}{character vector: fields to be returned by the request}

\item{filters}{named character vector: filters to be applied when retrieving records}

\item{num_records}{numeric: Number of records to retrieve}

\item{offset}{numeric: Number of results to skip in the beginning}

\item{sort}{named character vector: field to be sorted by and the order of sorting}

\item{q}{character: full text query filter}

\item{url}{character: The DKAN site URL}

\item{credentials}{Optional list parameter. Default values are Cookie and Token generated by dkan_setup()}

\item{as}{character: output format - json, list or data frame}
}
\value{
character, list, or data frame
}
\description{
Search csv resource file stored in the datastore.
}
\examples{
\dontrun{
ds_search_all(resource_id = '10c578a6-63c4-40bd-a55d-0c27bf276283',
          fields = c('Country','City','Region','Population'),
          filters = list('Country'=c('co','my'), 'Region'=c('04','09','22')),
          num_records = 20,
          offset = 0,
          limit = 100,
          sort = c('Country'='asc'),
          q = "puertica",
          url = get_url(),
          as = 'df')
}
}
