% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlhyper.R
\name{dlhyper}
\alias{dlhyper}
\title{Tune the hyperparameter in the prior distribtuion}
\usage{
dlhyper(x, y)
}
\arguments{
\item{x}{input matrix, each row is an observation vector, dimension n*p. Same as the argument in dlmain}

\item{y}{Response variable, a n*1 vector. Same as the argument in dlmain}
}
\value{
\item{hyper}{A value that can use in the following posterior computation}
}
\description{
This function is to tune the value of hyperparameter in the prior, which can
be [1/max(n,p),1/2]. We use the method proposed by Zhang et al. (2018). This method tune
 the hyperparameter by incorporating a prior on R^2. And they give a direct way to
 minimize KL directed divergence for special condition.
}
\examples{
p=50
n=6
#generate x
x=matrix(rnorm(n*p),nrow=n)
#generate beta
beta=c(rep(0,10),runif(n=5,min=-1,max=1),rep(0,10),runif(n=5,min=-1,max=1),rep(0,p-30))
#generate y
y=x\%*\%beta+rnorm(n)
hyper=dlhyper(x,y)


}
