% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examine-constraints.R
\name{dm_examine_constraints}
\alias{dm_examine_constraints}
\title{Validate your data model}
\usage{
dm_examine_constraints(
  .dm,
  ...,
  .progress = NA,
  dm = deprecated(),
  progress = deprecated()
)
}
\arguments{
\item{.dm}{A \code{dm} object.}

\item{...}{These dots are for future extensions and must be empty.}

\item{.progress}{Whether to display a progress bar, if \code{NA} (the default)
hide in non-interactive mode, show in interactive mode. Requires the
'progress' package.}

\item{dm, progress}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
A tibble with the following columns:
\describe{
\item{\code{table}}{the table in the \code{dm},}
\item{\code{kind}}{"PK" or "FK",}
\item{\code{columns}}{the table columns that define the key,}
\item{\code{ref_table}}{for foreign keys, the referenced table,}
\item{\code{is_key}}{logical,}
\item{\code{problem}}{if \code{is_key = FALSE}, the reason for that.}
}
}
\description{
This function returns a tibble with information about
which key constraints are met (\code{is_key = TRUE}) or violated (\code{FALSE}).
The printing for this object is special, use \code{\link[tibble:as_tibble]{tibble::as_tibble()}}
to print as a regular tibble.
}
\details{
For the primary key constraints, it is tested if the values in the respective columns are all unique.
For the foreign key constraints, the tests check if for each foreign key constraint, the values of the foreign key column
form a subset of the values of the referenced column.
}
\examples{
\dontshow{if (rlang::is_installed("nycflights13")) withAutoprint(\{ # examplesIf}
dm_nycflights13() \%>\%
  dm_examine_constraints()
\dontshow{\}) # examplesIf}
}
