% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-tbl.R
\name{dm_mutate_tbl}
\alias{dm_mutate_tbl}
\title{Update tables in a \code{\link{dm}}}
\usage{
dm_mutate_tbl(dm, ...)
}
\arguments{
\item{dm}{A \code{\link{dm}} object.}

\item{...}{One or more tables to update in the \code{dm}.
Must be named.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Updates one or more existing tables in a \code{\link{dm}}.
For now, the column names must be identical.
This restriction may be levied optionally in the future.
}
\examples{
\dontshow{if (rlang::is_installed("nycflights13")) withAutoprint(\{ # examplesIf}
dm_nycflights13() \%>\%
  dm_mutate_tbl(flights = nycflights13::flights[1:3, ])
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=dm]{dm()}}, \code{\link[=dm_select_tbl]{dm_select_tbl()}}
}
