% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmbc_fit.R
\name{dmbc_logLik_rbmds}
\alias{dmbc_logLik_rbmds}
\title{Log-likelihood for DMBC models.}
\usage{
dmbc_logLik_rbmds(D, Z, alpha)
}
\arguments{
\item{D}{A list whose elements are the dissimilarity matrices corresponding
to the judgments expressed by the \emph{S} subjects/raters. These matrices
must be defined as a \code{dist} object.}

\item{Z}{A numeric matrix containing the latent configuration.}

\item{alpha}{A numeric vector containing the alpha values.}
}
\value{
A length-one numeric vector of the log-likelihood value.
}
\description{
\code{dmbc_logLik_rbmds()} computes the log-likelihood value for a DMBC model.
}
\references{
Venturini, S., Piccarreta, R. (2021), "A Bayesian Approach for Model-Based
  Clustering of Several Binary Dissimilarity Matrices: the \pkg{dmbc}
  Package in \code{R}", Journal of Statistical Software, 100, 16, 1--35, <10.18637/jss.v100.i16>.
}
\seealso{
\code{\link{dmbc}()}.
}
\author{
Sergio Venturini \email{sergio.venturini@unicatt.it}
}
