% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frbd2fact.R
\name{frbd2fact}
\alias{frbd2fact}
\title{Analysis of Factorial Randomized Block Design for 2 factors}
\usage{
frbd2fact(data, replicationvector, fact.A, fact.B, Multiple.comparison.test)
}
\arguments{
\item{data}{dependent variables}

\item{replicationvector}{vector containing replications}

\item{fact.A}{vector containing levels of first factor}

\item{fact.B}{vector containing levels of second factor}

\item{Multiple.comparison.test}{0 for no test, 1 for LSD test, 2 for Duncan test and 3 for HSD test}
}
\value{
ANOVA, interpretation of ANOVA, R-square, normality test result, SEm, SEd and multiple comparison test results for both the factors as well as interaction.
}
\description{
The function gives ANOVA, R-square of the model, normality testing of residuals, SEm (standard error of mean), SEd (standard error of difference), interpretation of ANOVA results and multiple comparison test for means.
}
\examples{
data(factorialdata)
#FRBD analysis along with dunccan test for two dependent var.
frbd2fact(factorialdata[5:6],factorialdata$Replication,
factorialdata$Nitrogen,factorialdata$Phosphorus,2)
}
