% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitplot.R
\name{splitplot}
\alias{splitplot}
\title{Analysis of Split plot design}
\usage{
splitplot(data, block, main.plot, sub.plot, mean.comparison.test)
}
\arguments{
\item{data}{dependent variables}

\item{block}{vector containing replications}

\item{main.plot}{vector containing main-plot levels}

\item{sub.plot}{vector containing sub-plot levels}

\item{mean.comparison.test}{0 for no test, 1 for LSD test, 2 for Dunccan test and 3 for HSD test}
}
\value{
ANOVA, interpretation of ANOVA, R-square, normality test result, SEm, SEd and multiple comparison test result
}
\description{
The function gives ANOVA, R-square of the model, normality testing of residuals, SEm (standard error of mean), SEd (standard error of difference), interpretation of ANOVA results and multiple comparison test for means.
}
\examples{
data(splitdata)
#Using Date of sowing as Main-plot factor and varieties as sub-plot factor and using LSD test
#Split plot analysis with LSD test for Yield
splitplot(splitdata[4],splitdata$Replication,splitdata$Date_of_Sowing,splitdata$Varities,1)
#Split plot analysis with LSD test for both Yield and Plant Height
splitplot(splitdata[4:5],splitdata$Replication,splitdata$Date_of_Sowing,splitdata$Varities,1)
}
