% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{drawSettings}
\alias{drawSettings}
\title{Modify Default Drawing Settings}
\usage{
drawSettings(...)
}
\arguments{
\item{...}{Default settings to modify draw package settings stored in an environment.}
}
\value{
A list of the current draw settings with changes.
}
\description{
Modify Default Drawing Settings
}
\details{
The following parameters are available to change: \cr

\strong{*}
\itemize{
  \item \strong{units} [default = "inches"]: Character value of default measurement unit for applicable draw function parameters (such as width, height, radius, x, y, etc).
}

\link[grid]{arrow}
\itemize{
  \item \strong{arrowAngle} [default = 30]: Numeric value of the angle for arrows. Smaller numbers create narrower arrows, and larger numbers produce wider arrows.
  \item \strong{arrowLength} [default = 0]: Numeric value of the length for arrows.
  \item \strong{arrowUnits} [default = \emph{units}]: Character value of the measurement unit for arrows. Default is the same as \emph{units} parameter under \strong{*}.
  \item \strong{arrowEnds} [default = "last"]: Character value indicating which end to draw arrows on lines. Must be one of "last", "first" or "both".
  \item \strong{arrowType} [default = "open"]: Character value indicating if the arrow heads should be closed or open. Must be one of "open" or "closed".
}

\link{drawBox}
\itemize{
  \item \strong{boxWidth} [default = 1]: Numeric value of the width for boxes.
  \item \strong{boxHeight} [default = 1]: Numeric value of the height for boxes.
  \item \strong{boxRadius} [default = 0]: Numeric value of the radius for boxes to create rounded corners.
  \item \strong{boxFillColor} [default = "transparent"]: Character value of the color to fill boxes with.
  \item \strong{boxOpacity} [default = 1]: Numeric value of transparency for boxes ranging from 0 (transparent) to 1 (non-transparent).
  \item \strong{boxLineWidth} [default = 1]: Numeric value of the width for the box lines.
  \item \strong{boxLineType} [default = "solid"]: Character value of the type of line for the boxes. One of "blank", "solid", "dashed", "dotted", "dotdash", "longdash", or "twodash" (see "lty" in \link[graphics]{par}).
  \item \strong{boxLineColor} [default = "black"]: Character value of the color for the box lines.
}

\link{drawCircle}
\itemize{
  \item \strong{circleRadius} [default = 0.5]: Numeric value of the radius for circles.
  \item \strong{circleFillColor} [default = "transparent"]: Character value of the color to fill circles with.
  \item \strong{circleOpacity} [default = 1]: Numeric value of the transparency for circles ranging from 0 (transparent) to 1 (non-transparent).
  \item \strong{circleLineWidth} [default = 1]: Numeric value of the width for the circle lines.
  \item \strong{circleLineType} [default = "solid"]: Character value of the type of line for the circles. One of "blank", "solid", "dashed", "dotted", "dotdash", "longdash", or "twodash" (see "lty" in \link[graphics]{par}).
  \item \strong{circleLineColor} [default = "black"]: Character value of the color for the circle lines.
}

\link{drawCurve}
\itemize{
  \item \strong{curveCurvature} [default = 1]: Numeric value of the curvature for the curves. Values of 0 create a straight line, negative values create left-hand curves, and positive values create right-hand curves.
  \item \strong{curveAngle} [default = 90]: Numeric value of the curve control point skewness ranging from 0 to 180. Values less than 90 skew towards the start point, and values more than 90 skew towards the end point.
  \item \strong{curvePoints} [default = 1]: Numeric value of the number of control points for the curves, where higher values create smoother curves.
  \item \strong{curveShape} [default = 0.5]: Numeric value of the shape for the curves ranging from -1 to 1 (See \link[grid]{grid.xspline}).
  \item \strong{curveSquare} [default = TRUE]: Logical value indicating whether curve control points are created in a city-block or oblique way. It is recommended to set this to TRUE if \emph{curvePoints} is 1 and \emph{curveAngle} is 90, and FALSE otherwise (see \link[grid]{grid.curve}).
  \item \strong{curveSquareShape} [default = 1]: Numeric value controlling curve behaviours relative to control points. Applies if \emph{curveSquare} is TRUE.
  \item \strong{curveOpacity} [default = 1]: Numeric value of the transparency for the curves ranging from 0 (transparent) to 1 (non-transparent).
  \item \strong{curveLineColor} [default = "black"]: Character value of the color for the curve lines.
  \item \strong{curveLineWidth} [default = 1]: Character value of the width for the curve lines.
  \item \strong{curveLineType} [default = "solid"]: Character value of the type of line for the curves. One of "blank", "solid", "dashed", "dotted", "dotdash", "longdash", or "twodash" (see "lty" in \link[graphics]{par}).
  \item \strong{curveInflect} [default = FALSE]: Logical value indicating if curve should be cut in half and inverted (TRUE) or not (FALSE).
  \item \strong{curveOpen} [default = TRUE]: Logical value indicating whether to open the curves (TRUE) or close the curves (FALSE).
}

\link{drawExport}
\itemize{
  \item \strong{exportUnits} [default = \emph{units}]: Character value of measurement unit for exporting. Default is the same as \emph{units} parameter under \strong{*}.
  \item \strong{exportPPI} [default = 150]: Numeric value of the image quality measured in Pixels Per Inch (PPI).
}

\link{drawLine}
\itemize{
  \item \strong{lineOpacity} [default = 1]: Numeric value of the transparency of the lines ranging from 0 (transparent) to 1 (non-transparent).
  \item \strong{lineWidth} [default = 1]: Numeric value of the width of the lines.
  \item \strong{lineType} [default = "solid"]: Character value of the type for the lines. One of "blank", "solid", "dashed", "dotted", "dotdash", "longdash", or "twodash" (see "lty" in \link[graphics]{par}).
  \item \strong{lineColor} [default = "black"]: Character value of the color of the lines.
}

\link{drawPage}
\itemize{
  \item \strong{pageWidth} [default = 8.5]: Numeric value of the width of the drawing page.
  \item \strong{pageHeight} [default = 11]: Numeric value of the height of the drawing page.
}

\link{drawPoint}
\itemize{
  \item \strong{pointPCH} [default = 20]: Numeric value indicating which plotting symbol to use (see \link[graphics]{points}). Some examples include 0 for square, 1 for circle, 2 for triangle, and 4 for X.
  \item \strong{pointSize} [default = 1]: Numeric value of the point size.
  \item \strong{pointFillColor} [default = "transparent"]: Character value of the color to fill each point.
  \item \strong{pointOpacity} [default = 1]: Numeric value of the transparency for the points ranging from 0 (transparent) to 1 (non-transparent).
  \item \strong{pointLineColor} [default = "black"]: Character value of the color of the points.
  \item \strong{pointLineType} [default = "solid"]: Character value of the type for the lines. One of "blank", "solid", "dashed", "dotted", "dotdash", "longdash", or "twodash" (see "lty" in \link[graphics]{par}).
  \item \strong{pointLineWidth} [default = 1]: Numeric value of the width of the point lines.
}

\link{drawText}
\itemize{
  \item \strong{text} [default = "text"]: Character value of the text to display at the defined position.
  \item \strong{textJust} [default = "centre"]: Character value of the text justification. One of "left", "right", "centre", "center", "bottom", or "top".
  \item \strong{textHjust} [default = NULL]: Numeric value of the horizontal justification.
  \item \strong{textVjust} [default = NULL]: Numeric value of the vertical justification.
  \item \strong{textAngle} [default = 0]: Numeric value of the angle to rotate text.
  \item \strong{textOverlap} [default = FALSE]: Logical value indicating if overlapping text should be removed (TRUE) or not (FALSE).
  \item \strong{textOpacity} [default = 1]: Numeric value of the transparency for text ranging from 0 (transparent) to 1 (non-transparent).
  \item \strong{textColor} [default = "black"]: Character value of the color for text.
  \item \strong{textSize} [default = 12]: Numeric value of the text font size in pt.
  \item \strong{textFace} [default = "plain"]: Character value of the text font face. One of "plain", "bold", "italic", "oblique", and "bold.italic" (see \emph{fontface} in \link[grid]{gpar}).
  \item \strong{textFamily} [default = "sans"]: Character value of text font family to use (see \emph{family} in \link[graphics]{par}). Common values are "serif", "sans" and "mono".
  \item \strong{textLineHeight} [default = 1.2]: Numeric value of text line height as a multiple of the size of the text.
}
}
\examples{
library(draw)

# Set page dimensions and units to inches
drawSettings(pageWidth = 5, pageHeight = 5, units = "inches")

# Set export resolution in Pixels Per Inch (PPI)
drawSettings(exportPPI = 300)

# Set default width and height for all boxes in inches
drawSettings(boxWidth = 1, boxHeight = 1)

# Create a new drawing page
drawPage()

# Draw default 1 by 1 inch boxes near the center
drawBox(x = 2, y = 2.5)
drawBox(x = 3, y = 2.5)

# Draw a non-default 2 by 2 inch box in the center
drawBox(x = 2.5, y = 2.5, width = 2, height = 2)

# Export the current drawing page
drawExport("drawSettingsExample.pdf")

}
