% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{toCanvasTextBtn}
\alias{toCanvasTextBtn}
\title{Screenshot HTML elements to canvas text-button}
\usage{
toCanvasTextBtn(
  canvasID,
  label = "",
  text_value = "",
  placeholder = "type a selector",
  tooltip = "Screenshot any element to drawer canvas",
  placement = "bottom",
  btn_label = "To Canvas",
  color_class = "primary",
  style = ""
)
}
\arguments{
\item{canvasID}{string, the ID of canvas.}

\item{label}{string, label of the whole group, on the top}

\item{text_value}{string, nitial value of the text input}

\item{placeholder}{string, placeholder text of the text input}

\item{tooltip}{a tooltip of the group}

\item{placement}{where should the tooltip go?}

\item{btn_label}{text on the button}

\item{color_class}{bootstrap button color class suffix, usually one of
'default', 'primary', 'info', 'success', 'warning', 'danger'}

\item{style}{additional CSS style of the group, like "width: 50\%"}
}
\value{
a shiny input group
}
\description{
Unlike \link{toCanvasBtn} only screenshot a defined element, this function
can take screenshot of any element you specify in the text box and sent to canvas
by using Jquery  selector format.
}
\details{
This component will not work unless a drawer canvas has been loaded
on current document.
\subsection{Input selector}{

The selector uses Jquery selector.
\itemize{
\item If you are not familiar with it, just remember
the mostly commonly used is the element ID, which is the \code{inputID}, \code{ID} arguments
in most Shiny components. Jquery selector is almost the same for ID, but requires
you to add "#" in front, "#element-ID".
\item If you have no idea about shiny or HTML selector, right click on the element,
and click inspect, you should see the document HTML code in the inspector and
the element you want should be highlighted. Find the attribute of "\emph{id}", that's
what you need. Again, append "#" in front of that value. Some elements do not
have an "id", in this case, you need some advanced selectors. Learn about them by
Google "CSS selector".
}
}
}
\examples{
# see the example of "canvas", `?canvas`
}
