% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmm.R
\name{getTransitionMatrix.dmm}
\alias{getTransitionMatrix.dmm}
\title{Get transition matrix of the drifting Markov Model}
\usage{
\method{getTransitionMatrix}{dmm}(x, pos)
}
\arguments{
\item{x}{An object of class \code{dmm}}

\item{pos}{A positive integer giving the position along the sequence on which the transition matrix of the DMM should be computed}
}
\value{
A transition matrix at a given position
}
\description{
Evaluate the transition matrix of the DMM at a given position
}
\examples{
data(lambda, package = "drimmR")
dmm <- fitdmm(lambda, 1, 1, c('a','c','g','t'),init.estim = "freq", fit.method="sum")
t <- 10
getTransitionMatrix(dmm,pos=t)
}
\references{
\insertRef{BaVe2018}{drimmR}
\insertRef{Ver08}{drimmR}
}
\seealso{
\link[drimmR]{fitdmm}
}
\author{
Victor Mataigne, Alexandre Seiller
}
