% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_kpm.R
\name{plot_do_kpm}
\alias{plot_do_kpm}
\title{Plot a Kaplan Meier Survival Estimation}
\usage{
plot_do_kpm(
  kds,
  sel_conds = c("11", "12", "21", "22"),
  kpm_ci = TRUE,
  full_scale_kpm = FALSE,
  color_palette_kp = "color_blind"
)
}
\arguments{
\item{kds}{list object as modeled by \code{\link[=do_kpm]{do_kpm()}}}

\item{sel_conds}{character Which experimental conditions to plot.}

\item{kpm_ci}{boolean Should there be confidence bands in the plot? Defaults to TRUE.}

\item{full_scale_kpm}{boolean Should the Y axis show the full range from 0 to 100? Defaults to FALSE.}

\item{color_palette_kp}{character indicating which color palette to use. Defaults to 'color_blind',
alternatively choose 'gray' for gray scale values or 'default' for the ggplot2 default colors.}
}
\value{
Returns a \code{ggplot} object containing the Kaplan-Meier survival plot. Using the Shiny App version of
dropR, this plot can easily be downloaded in different formats.
}
\description{
The \code{plot_do_kpm} function generates a Kaplan-Meier survival plot based on the
output from the \code{\link[=do_kpm]{do_kpm()}} function. It allows for customization of conditions
to display, confidence intervals, color palettes, and y-axis scaling.
}
\examples{
plot_do_kpm(do_kpm(d = add_dropout_idx(dropRdemo, 3:54),
condition_col = "experimental_condition",
model_fit = "total"))

plot_do_kpm(do_kpm(d = add_dropout_idx(dropRdemo, 3:54),
condition_col = "experimental_condition",
model_fit = "conditions"), sel_conds = c("11", "12", "21", "22"))

}
