% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_iptw.R
\name{adaptive_iptw}
\alias{adaptive_iptw}
\title{Compute asymptotically linear IPTW estimators with super learning
for the propensity score}
\usage{
adaptive_iptw(W, A, Y, DeltaY = as.numeric(!is.na(Y)),
  DeltaA = as.numeric(!is.na(A)), stratify = FALSE, family = if (all(Y
  \%in\% c(0, 1))) {     stats::binomial() } else {     stats::gaussian() },
  a_0 = unique(A[!is.na(A)]), SL_g = NULL, glm_g = NULL, SL_Qr = NULL,
  glm_Qr = NULL, returnModels = TRUE, verbose = FALSE, maxIter = 2,
  tolIC = 1/length(Y), tolg = 0.01, cvFolds = 1, gn = NULL, ...)
}
\arguments{
\item{W}{A \code{data.frame} of named covariates}

\item{A}{A \code{numeric} vector of binary treatment assignment (assumed to
be equal to 0 or 1)}

\item{Y}{A \code{numeric} numeric of continuous or binary outcomes.}

\item{DeltaY}{A \code{numeric} indicator of missing outcome (assumed to be
equal to 0 if missing 1 if observed)}

\item{DeltaA}{A \code{numeric} indicator of missing treatment (assumed to be
equal to 0 if missing 1 if observed)}

\item{stratify}{A \code{logical} indicating whether to estimate the missing
outcome regression separately for observations with different levels of
\code{A} (if \code{TRUE}) or to pool across \code{A} (if \code{FALSE}).}

\item{family}{A \code{family} object equal to either \code{binomial()} or
\code{gaussian()}, to be passed to the \code{SuperLearner} or \code{glm}
function.}

\item{a_0}{A vector of \code{numeric} treatment values at which to return
marginal mean estimates.}

\item{SL_g}{A vector of characters describing the super learner library to be
used for each of the propensity score regressions (\code{DeltaA}, \code{A},
and \code{DeltaY}). To use the same library for each of the regressions (or
if there is no missing data in \code{A} nor \code{Y}), a single library may
be input. See \code{link{SuperLearner::SuperLearner}} for details on how
super learner libraries can be specified.}

\item{glm_g}{A list of characters describing the formulas to be used
for each of the propensity score regressions (\code{DeltaA}, \code{A}, and
\code{DeltaY}). To use the same formula for each of the regressions (or if
there is no missing data in \code{A} nor \code{Y}), a single character
formula may be input.}

\item{SL_Qr}{A vector of characters or a list describing the Super Learner
library to be used for the reduced-dimension outcome regression.}

\item{glm_Qr}{A character describing a formula to be used in the call to
\code{glm} for reduced-dimension outcome regression. Ignored if
\code{SL_Qr!=NULL}. The formula should use the variable name \code{'gn'}.}

\item{returnModels}{A logical indicating whether to return model fits for the
propensity score and reduced-dimension regressions.}

\item{verbose}{A logical indicating whether to print status updates.}

\item{maxIter}{A numeric that sets the maximum number of iterations the TMLE
can perform in its fluctuation step.}

\item{tolIC}{A numeric that defines the stopping criteria based on the
empirical mean of the influence function.}

\item{tolg}{A numeric indicating the minimum value for estimates of the
propensity score.}

\item{cvFolds}{A numeric equal to the number of folds to be used in
cross-validated fitting of nuisance parameters. If \code{cvFolds = 1}, no
cross-validation is used.}

\item{gn}{An optional list of propensity score estimates. If specified, the
function will ignore the nuisance parameter estimation specified by
\code{SL_g} and \code{glm_g}. The entries in the list should correspond to
the propensity for the observed values of \code{W}, with order determined by
the input to \code{a_0} (e.g., if \code{a_0 = c(0,1)} then \code{gn[[1]]}
should be propensity of \code{A} = 0 and \code{gn[[2]]} should be propensity
of \code{A} = 1).}

\item{...}{Other options (not currently used).}
}
\value{
An object of class \code{"adaptive_iptw"}.
\describe{
\item{\code{iptw_tmle}}{A \code{list} of point estimates and
covariance matrix for the IPTW estimator based on a targeted
propensity score. }
\item{\code{iptw_tmle_nuisance}}{A \code{list} of the final TMLE estimates
of the propensity score (\code{$gnStar}) and reduced-dimension
regression (\code{$QrnStar}) evaluated at the observed data values.}
\item{\code{iptw_os}}{A \code{list} of point estimates and covariance matrix
for the one-step correct IPTW estimator.}
\item{\code{iptw_os_nuisance}}{A \code{list} of the initial estimates of the
propensity score and reduced-dimension regression evaluated at the
observed data values.}
\item{\code{iptw}}{A \code{list} of point estimates for the standard IPTW
estimator. No estimate of the covariance matrix is provided because
theory does not support asymptotic Normality of the IPTW estimator if
super learning is used to estimate the propensity score.}
\item{\code{gnMod}}{The fitted object for the propensity score. Returns
\code{NULL} if \code{returnModels = FALSE}.}
\item{\code{QrnMod}}{The fitted object for the reduced-dimension regression
that guards against misspecification of the outcome regression.
Returns \code{NULL} if \code{returnModels = FALSE}.}
\item{\code{a_0}}{The treatment levels that were requested for computation
of covariate-adjusted means.}
\item{\code{call}}{The call to \code{adaptive_iptw}.}
}
}
\description{
Compute asymptotically linear IPTW estimators with super learning
for the propensity score
}
\examples{
# load super learner
library(SuperLearner)
# simulate data
set.seed(123456)
n <- 100
W <- data.frame(W1 = runif(n), W2 = rnorm(n))
A <- rbinom(n, 1, plogis(W$W1 - W$W2))
Y <- rbinom(n, 1, plogis(W$W1 * W$W2 * A))
# fit iptw with maxIter = 1 to run fast
\donttest{
fit1 <- adaptive_iptw(
  W = W, A = A, Y = Y, a_0 = c(1, 0),
  SL_g = c("SL.glm", "SL.mean", "SL.step"),
  SL_Qr = "SL.npreg", maxIter = 1
)
}
}
