% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_bias_generic.R
\name{optimal_bias_generic}
\alias{optimal_bias_generic}
\title{Generic function for optimizing drug development programs with bias adjustment}
\usage{
optimal_bias_generic(
  adj = "both",
  lambdamin = NULL,
  lambdamax = NULL,
  steplambda = NULL,
  alphaCImin = NULL,
  alphaCImax = NULL,
  stepalphaCI = NULL
)
}
\arguments{
\item{adj}{choose type of adjustment: \code{"multiplicative"},
\code{"additive"}, \code{"both"} or \code{"all"}. When using "both",
\code{res[1,]} contains the results using the multiplicative method and \code{res[2,]}
contains the results using the additive method. When using "all", there are
also \code{res[3,]} and \code{res[4,]}, containing the results of a multiplicative
and an additive method which do not only adjust the treatment effect but
also the threshold value for the decision rule.}

\item{lambdamin}{minimal multiplicative adjustment parameter lambda (i.e. use estimate with a retention factor)}

\item{lambdamax}{maximal multiplicative adjustment parameter lambda (i.e. use estimate with a retention factor)}

\item{steplambda}{stepsize for the adjustment parameter lambda}

\item{alphaCImin}{minimal additive adjustment parameter alphaCI (i.e. adjust the lower bound of the one-sided confidence interval)}

\item{alphaCImax}{maximal additive adjustment parameter alphaCI (i.e. adjust the lower bound of the one-sided confidence interval)}

\item{stepalphaCI}{stepsize for alphaCI}
}
\description{
Generic function for optimizing drug development programs with bias adjustment
}
\keyword{internal}
