% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_generic.R
\name{optimal_generic}
\alias{optimal_generic}
\title{Generic function for optimizing drug development programs}
\usage{
optimal_generic(beta, alpha, c2, c3, c02, c03, K, N, S, b1, b2, b3, num_cl)
}
\arguments{
\item{c2}{variable per-patient cost for phase II}

\item{c3}{variable per-patient cost for phase III}

\item{c02}{fixed cost for phase II}

\item{c03}{fixed cost for phase III}

\item{K}{constraint on the costs of the program, default: \code{Inf}, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: \code{Inf}, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: \code{-Inf}, e.g. no constraint}

\item{b1}{expected gain for effect size category "small"}

\item{b2}{expected gain for effect size category "medium"}

\item{b3}{expected gain for effect size category "large"}

\item{num_cl}{number of clusters used for parallel computing, default: 1}
}
\description{
Generic function for optimizing drug development programs
}
\keyword{internal}
