% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multiple_tte.R
\name{utility_multiple_tte}
\alias{utility_multiple_tte}
\title{Utility function for multiple endpoints in a time-to-event-setting}
\usage{
utility_multiple_tte(
  n2,
  HRgo,
  alpha,
  beta,
  hr1,
  hr2,
  id1,
  id2,
  c2,
  c02,
  c3,
  c03,
  K,
  N,
  S,
  steps1,
  stepm1,
  stepl1,
  b11,
  b21,
  b31,
  b12,
  b22,
  b32,
  fixed,
  rho,
  rsamp
)
}
\arguments{
\item{n2}{total sample size for phase II; must be even number}

\item{HRgo}{threshold value for the go/no-go decision rule;}

\item{alpha}{significance level}

\item{beta}{\code{1-beta} power for calculation of sample size for phase III}

\item{hr1}{assumed true treatment effect on HR scale for endpoint OS}

\item{hr2}{assumed true treatment effect on HR scale for endpoint PFS}

\item{id1}{amount of information for \code{hr1} in terms of sample size}

\item{id2}{amount of information for \code{hr2} in terms of sample size}

\item{c2}{variable per-patient cost for phase II}

\item{c02}{fixed cost for phase II}

\item{c3}{variable per-patient cost for phase III}

\item{c03}{fixed cost for phase III}

\item{K}{constraint on the costs of the program, default: Inf, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: Inf, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: -Inf, e.g. no constraint}

\item{steps1}{lower boundary for effect size category \code{"small"} in HR scale, default: 1}

\item{stepm1}{lower boundary for effect size category \code{"medium"} in HR scale = upper boundary for effect size category \code{"small"} in HR scale, default: 0.95}

\item{stepl1}{lower boundary for effect size category \code{"large"} in HR scale = upper boundary for effect size category \code{"medium"} in HR scale, default: 0.85}

\item{b11}{expected gain for effect size category \code{"small"} if endpoint OS is significant}

\item{b21}{expected gain for effect size category \code{"medium"}if endpoint OS is significant}

\item{b31}{expected gain for effect size category \code{"large"} if endpoint OS is significant}

\item{b12}{expected gain for effect size category \code{"small"} if endpoint OS is not significant}

\item{b22}{expected gain for effect size category \code{"medium"}if endpoint OS is not significant}

\item{b32}{expected gain for effect size category \code{"large"} if endpoint OS is not significant}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE \code{hr1} is used as fixed effect}

\item{rho}{correlation between the two endpoints}

\item{rsamp}{sample data set for Monte Carlo integration}
}
\value{
The output of the function \code{utility_multiple_tte()} is the expected utility of the program.
}
\description{
The utility function calculates the expected utility of our drug development program and is given as gains minus costs and depends on the parameters and the expected probability of a successful program.
The utility is in a further step maximized by the \code{optimal_multiple_tte()} function.
Note, that for calculating the utility of the program, two different benefit triples are necessary:
\itemize{
\item one triple for the case that the more important endpoint overall survival (OS) shows a significant positive treatment effect
\item one triple when only the endpoint progression-free survival (PFS) shows a significant positive treatment effect
}
}
\keyword{internal}
