% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap.R
\name{isolate_overlaps}
\alias{isolate_overlaps}
\title{Separating overlapping prescription periods}
\usage{
isolate_overlaps(data)
}
\arguments{
\item{data}{A data frame including variables \code{patid}, \code{start_date},
\code{stop_date} and \code{prodcode}}
}
\value{
A data frame of \code{patid}, \code{prodcode}, \code{start_date} and
\code{stop_date}, where intervals are either exactly overlapping or mutually
non-overlapping (but not partially overlapping), such that the union of such
intervals is equivalent to those originally provided in \code{data}
}
\description{
Run this function and then you can either simply discard overlapping
intervals or shift them around using an appropriate algorithm.
}
\details{
The older implementation used \code{isolateoverlaps} from the
\code{intervalaverage} package and \code{Overlap} from the \code{DescTools}
package. Here we refactor it using functions from \code{tidyverse} instead.
}
\note{
This function currently doesn't use any keys except \code{patid} and
\code{prodcode}. It may be desirable to add a row ID, for matching each
partial interval back to the original interval from which it was derived.
This may be relevant to models using weighted dosages.
}
\examples{
set.seed(1)
overlapping_data <- data.frame(
  rowid = 1:20,
  patid = 1:2,
  prodcode = 'a',
  start_date = Sys.Date() + c(round(rexp(19, 1/7)), -20),
  qty = rpois(20, 64),
  ndd = sample(seq(.5, 12, by = .5), 20, replace = TRUE),
  stringsAsFactors = FALSE
)
overlapping_data <- transform(overlapping_data,
  stop_date = start_date + qty / ndd
)
isolate_overlaps(overlapping_data)

}
\seealso{
\code{intervalaverage::isolateoverlaps},
\code{\link[data.table]{foverlaps}}
}
