% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expmodel.r
\name{estimate.expmodel}
\alias{estimate.expmodel}
\title{Estimate Exponential-based model \code{expmodel}}
\usage{
\method{estimate}{expmodel}(
  model,
  deglist = deglist,
  lmdlist = lmdlist,
  recompute = FALSE,
  stepsize = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{model}{An object of \code{expmodel} class.}

\item{deglist}{A vector of degrees of polynomials. The element should be
positive integers.}

\item{lmdlist}{A vector of rate parameters of Exponential-based models.
The element should be larger than 0.}

\item{recompute}{If \code{TRUE}, recomputes the results for
better estimation and accuracy. Parameters whose accuracies had been already
attained sufficiently, namely around 1.0e-6, are not included in candidates
for recomputing.}

\item{stepsize}{A vector in descending order whose values are
between 0 and 1.
If a small step size is supplied, it can attain successful estimates,
but it might take more iterations.}

\item{verbose}{If \code{TRUE}, it shows the detailed message of SDP solver.}

\item{...}{Arguments to be passed to or from other methods.}
}
\value{
A \code{expmodel} object including the estimates.
Those estimates are stored in \code{model$result} with
\code{data.frame} format and \code{model$coeffs} in \code{list} format.
}
\description{
Estimates Exponential-based model \code{expmodel} among
parameter vectors, \code{deglist}, \code{lmdlist}.
Then it sorts the results by AIC.
}
\examples{
## Create an expmodel object
emodel <- expmodel(mixexpgamma$n200)
## Estimate a model with parameters
emodel <- estimate(emodel, deglist=c(4,5), lmdlist=c(0.5, 1, 2))
}
\seealso{
\code{\link[=expmodel]{expmodel()}} \code{\link[=summary.expmodel]{summary.expmodel()}} \code{\link[=plot.expmodel]{plot.expmodel()}}
}
