% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct_fill_col.R
\name{dct_fill_col}
\alias{dct_fill_col}
\title{Fill a column of a taxonomic database}
\usage{
dct_fill_col(
  tax_dat,
  fill_to = "acceptedNameUsage",
  fill_from = "scientificName",
  match_to = "taxonID",
  match_from = "acceptedNameUsageID",
  stamp_modified = dct_options()$stamp_modified
)
}
\arguments{
\item{tax_dat}{Dataframe; taxonomic database in DwC format.}

\item{fill_to}{Character vector of length 1; name of column to fill.
If the column does not yet exist it will be created.}

\item{fill_from}{Character vector of length 1; name of column to copy
values from when filling.}

\item{match_to}{Character vector of length 1; name of column to match to.}

\item{match_from}{Character vector of length 1; name of column to match from.}

\item{stamp_modified}{Logical vector of length 1; should the \code{modified} column of any newly created or modified row include a timestamp with the date and time of its creation/modification? If the \code{modified} column does not yet exist it will be created. Default \code{TRUE}.}
}
\value{
Dataframe; taxonomic database in DwC format.
}
\description{
Fill a column in a taxonomic database in Darwin Core (DwC) format.
}
\details{
Several terms (columns) in DwC format come in pairs of "term" and "termID";
for example, "acceptedNameUsage" and "acceptedNameUsageID", where the first
is the value in a human-readable form (in this case, scientific name of the
accepted taxon) and the second is the value used by a machine (in this case,
taxonID of the accepted taxon). Other pairs include "parentNameUsage" and
"parentNameUsageID", "scientificName" and "scientificNameID", etc. None are
required to be used in a given DwC dataset.

Often when updating data, the user may only fill in one value or the other
(e.g., "acceptedNameUsage" or "acceptedNameUsageID"), but not both. The
purpose of \code{dct_fill_col()} is to fill the missing column.

\code{match_from} and \code{match_to} are used to locate the values used for filling
each cell. The values in the \code{match_to} column must be unique.

The default settings are to fill acceptedNameUsage with values from
scientificName by matching acceptedNameUsageID to taxonID (see Example).

When adding timestamps with \code{stamp_modified}, any row that differs from the
original data (\code{tax_dat}) is considered modified. This includes when a new
column is added, in which case all rows will be considered modified.
}
\examples{
# Fill acceptedNameUsage with values from scientificName by
# matching acceptedNameUsageID to taxonID
(head(dct_filmies, 5)) |>
  dct_fill_col(
    fill_to = "acceptedNameUsage",
    fill_from = "scientificName",
    match_to = "taxonID",
    match_from = "acceptedNameUsageID"
  )
}
