% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_convert.R
\name{as_dyno}
\alias{as_dyno}
\alias{as_anndata}
\alias{as_sce}
\alias{as_seurat}
\alias{as_list}
\alias{wrap_dataset}
\title{Convert simulation output to different formats.}
\usage{
as_dyno(
  model,
  store_dimred = !is.null(model$simulations$dimred),
  store_cellwise_grn = !is.null(model$experiment$cellwise_grn),
  store_rna_velocity = !is.null(model$experiment$rna_velocity)
)

as_anndata(
  model,
  store_dimred = !is.null(model$simulations$dimred),
  store_cellwise_grn = !is.null(model$experiment$cellwise_grn),
  store_rna_velocity = !is.null(model$experiment$rna_velocity)
)

as_sce(
  model,
  store_dimred = !is.null(model$simulations$dimred),
  store_cellwise_grn = !is.null(model$experiment$cellwise_grn),
  store_rna_velocity = !is.null(model$experiment$rna_velocity)
)

as_seurat(
  model,
  store_dimred = !is.null(model$simulations$dimred),
  store_cellwise_grn = !is.null(model$experiment$cellwise_grn),
  store_rna_velocity = !is.null(model$experiment$rna_velocity)
)

as_list(
  model,
  store_dimred = !is.null(model$simulations$dimred),
  store_cellwise_grn = !is.null(model$experiment$cellwise_grn),
  store_rna_velocity = !is.null(model$experiment$rna_velocity)
)

wrap_dataset(
  model,
  format = c("list", "dyno", "sce", "seurat", "anndata", "none"),
  store_dimred = !is.null(model$simulations$dimred),
  store_cellwise_grn = !is.null(model$experiment$cellwise_grn),
  store_rna_velocity = !is.null(model$experiment$rna_velocity)
)
}
\arguments{
\item{model}{A dyngen output model for which the experiment has been emulated with \code{\link[=generate_experiment]{generate_experiment()}}.}

\item{store_dimred}{Whether or not to store the dimensionality reduction constructed on the true counts.}

\item{store_cellwise_grn}{Whether or not to also store cellwise GRN information.}

\item{store_rna_velocity}{WHether or not to store the log propensity ratios.}

\item{format}{Which output format to use, must be one of 'dyno' (requires \code{dynwrap}), 'sce' (requires \code{SingleCellExperiment}), 'seurat' (requires \code{Seurat}), 'anndata' (requires \code{anndata}), 'list' or 'none'.}
}
\value{
A dataset object.
}
\description{
For use with other packages compatible with dyno, anndata, SingleCellExperiment, or Seurat.
}
\examples{
data("example_model")
dataset <- wrap_dataset(example_model, format = "list")
\donttest{
dataset <- wrap_dataset(example_model, format = "dyno")
dataset <- wrap_dataset(example_model, format = "sce")
dataset <- wrap_dataset(example_model, format = "seurat")
dataset <- wrap_dataset(example_model, format = "anndata")
dataset <- wrap_dataset(example_model, format = "none")
}
}
