% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_gold_simulations}
\alias{plot_gold_simulations}
\title{Visualise the simulations using the dimred}
\usage{
plot_gold_simulations(
  model,
  detailed = FALSE,
  mapping = aes_string("comp_1", "comp_2"),
  highlight = 0
)
}
\arguments{
\item{model}{A dyngen intermediary model for which the simulations have been run with \code{\link[=generate_cells]{generate_cells()}}.}

\item{detailed}{Whether or not to colour according to each separate sub-edge in the gold standard.}

\item{mapping}{Which components to plot.}

\item{highlight}{Which simulation to highlight. If highlight == 0 then the gold simulation will be highlighted.}
}
\value{
A ggplot2 object.
}
\description{
Visualise the simulations using the dimred
}
\examples{
data("example_model")
plot_gold_simulations(example_model)
}
