% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hlevel.R
\name{hlevel}
\alias{hlevel}
\title{Height level for given diameter or area.}
\usage{
hlevel(ds, H, D, b, bh, area = FALSE)
}
\arguments{
\item{ds}{The given diameter or area.}

\item{H}{Tree total height.}

\item{D}{Tree diameter at breast height.}

\item{b}{Vector with the 5 parameters.}

\item{bh}{Breast height. Typically 1.2, 1.3 or 1.4 m, or 4.5 ft.}

\item{area}{If TRUE, '\code{ds}' is a cross-sectional area, otherwise a
diameter. Default is FALSE.}
}
\value{
Height level corresponding to '\code{ds}' if any, otherwise \code{NA}.
}
\description{
Find the height level at which the tree reaches a given diameter (if
    \code{area == FALSE}, default) or a given cross-sectional area (if
    \code{area == TRUE}).
    That is, the inverse of \code{taper()}, except that a vector argument
    is not allowed.
}
\examples{
   b <- c(2.569, 0, 1.042, 0.3012, -1)  # parameters
   Dib <- 0.956 * 24  # convert dbh outside bark to inside bark 
   hlevel(15, 32, Dib, b, 1.3)  # height where the diameter is 15
   hlevel(24, 32, Dib, b, 1.3)  # breast height
   hlevel(35, 32, Dib, b, 1.3)  # height where the diameter is 35

}
