% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_review.R
\name{cellspec_lgl}
\alias{cellspec_lgl}
\title{Kable logical data highlighting}
\usage{
cellspec_lgl(.data, rg = FALSE)
}
\arguments{
\item{.data}{Table to be highlighted.}

\item{rg}{Should red and green be used for \code{TRUE} and \code{FALSE} values, respectively? If FALSE (default), colour-blind-friendly colours are applied.}
}
\value{
Table with cell colours specified.
}
\description{
Adds colour highlighting to cell values if they are encoded as logical
values. Output should then be passed to \code{knitr}'s \code{kable}
function.
}
\details{
This is useful for identifying the encoding used in a value (e.g. the
difference between the string "TRUE" and truth value of logic \code{TRUE}).
This highlighting can also be useful when visually assessing cell values in
a table. The colour naming format (HTML or LaTeX) is automatically detected.
There are four cell types considered:
\enumerate{
   \item non-logical cells are coloured black)
   \item{\code{TRUE} cells are coloured red (default) or green if \code{rg}
   is \code{TRUE}}
   \item{\code{FALSE} cells are coloured cyan (default) or red if \code{rg}
   is \code{TRUE}}
   \item{\code{NA} cells are coloured gray}
   }

Note: When passed to \code{kable()}, the \code{escape} parameter should be
\code{FALSE} for colours to be rendered correctly.
}
\seealso{
\code{\link[knitr]{kable}} \code{\link[kableExtra]{cell_spec}}
}
