% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core3D.R
\name{n.sim.cond.3d}
\alias{n.sim.cond.3d}
\title{Conditional Empirical Random Walks (CERW) in 3-D}
\usage{
n.sim.cond.3d(
  n.sim,
  n.locs,
  start = c(0, 0, 0),
  end = start,
  a0,
  g0,
  densities,
  qProbs,
  error = FALSE,
  parallel = FALSE,
  DEM = NULL,
  BG = NULL
)
}
\arguments{
\item{n.sim}{number of CERWs to simulate}

\item{n.locs}{length of the trajectory in locations}

\item{start}{numeric vector of length 3 with the coordinates of the start point}

\item{end}{numeric vector of length 3 with the coordinates of the end point}

\item{a0}{initial incoming heading in radian}

\item{g0}{initial incoming gradient/polar angle in radian}

\item{densities}{list object returned by the \link[eRTG3D]{get.densities.3d} function}

\item{qProbs}{list object returned by the \link[eRTG3D]{qProb.3d} function}

\item{error}{logical: add random noise to the turn angle, lift angle and step length to account for errors measurements?}

\item{parallel}{logical: run computations in parallel (n-1 cores)? Or numeric: the number of nodes (maximum: n - 1 cores)}

\item{DEM}{raster layer containing a digital elevation model, covering the area between start and end point}

\item{BG}{a background raster layer that can be used to inform the choice of steps}
}
\value{
A list containing the CERWs or \code{NULL}s if dead ends have been encountered.
}
\description{
Creates multiple conditional empirical random walks, with a specific starting and ending point,
geometrically similar to the initial trajectory by applying \link[eRTG3D]{sim.cond.3d} multiple times.
}
\examples{
niclas <- track.properties.3d(niclas)
n.locs <- 3
P <- get.track.densities.3d(niclas)
f <- 1500
start <- Reduce(c, niclas[1, 1:3])
end <- Reduce(c, niclas[n.locs, 1:3])
a0 <- niclas$a[1]
g0 <- niclas$g[1]
uerw <- sim.uncond.3d(
  n.locs * f, start = start, a0 = a0, g0 = g0, densities = P
)
Q <- qProb.3d(uerw, n.locs)
n.sim.cond.3d(
  n.sim = 2, n.locs = n.locs,
  start = start, end = end,
  a0 = a0, g0 = g0,
  densities = P, qProbs = Q
)
}
