% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fillImputations.R
\name{fillImputations}
\alias{fillImputations}
\title{Fill imputed values.}
\usage{
fillImputations(GADSdat, GADSdat_imp, varName, varName_imp = varName, id, imp)
}
\arguments{
\item{GADSdat}{A \code{GADSdat} object.}

\item{GADSdat_imp}{A \code{GADSdat} object.}

\item{varName}{A character vector of length 1 containing the variable name in \code{GADSdat}.}

\item{varName_imp}{A character vector of length 1 containing the variable name in \code{GADSdat_imp}.}

\item{id}{A character vector of length 1 containing the unique identifier column of both \code{GADSdat}.}

\item{imp}{A character vector of length 1 containing the imputation number in \code{GADSdat_imp}.}
}
\value{
The modified \code{GADSdat_imp}..
}
\description{
Fill imputed values in a imputed \code{GADSdat_imp} object with original, not imputed values from a \code{GADSdat}.
}
\details{
This function only fills in missing values in the imputed variable from the not imputed variable. It provides parts
of the functionality of \code{subImputations} but does not check whether values have been mistakenly imputed. However,
performance is increased substantially.
}
\examples{
# tbd

}
