% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ed_get.R
\name{ed_get_datasets}
\alias{ed_get_datasets}
\title{List available datasets in the EconDataverse organization}
\usage{
ed_get_datasets(quiet = FALSE)
}
\arguments{
\item{quiet}{Logical; whether to suppress informational messages.
Defaults to FALSE.}
}
\value{
A data frame with columns:
\describe{
\item{dataset}{Dataset identifier on Hugging Face}
\item{total_downloads}{Approximate download count}
\item{last_modified}{Last update timestamp (UTC)}
\item{is_private}{Logical; whether the dataset is private}
\item{is_gated}{Logical; whether access is gated}
}
Returns \code{NULL} if the request fails.
}
\description{
Retrieves a list of all datasets published under the
\href{https://huggingface.co/econdataverse}{EconDataverse} organization
on Hugging Face.
}
\examples{
\donttest{
ed_get_datasets()
}

}
