% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add_short_names_column}
\alias{add_short_names_column}
\title{Add Short Names to Country Data}
\usage{
add_short_names_column(df, id_column, target_column = "name_short")
}
\arguments{
\item{df}{A data frame containing country identifiers.}

\item{id_column}{Name of the column containing country identifiers.}

\item{target_column}{Name of the output column. Defaults to "name_short".}
}
\value{
A data frame with an additional column containing the short names.
}
\description{
Add Short Names to Country Data
}
\examples{
# Add short names using ISO3 codes
df <- data.frame(country = c("USA", "FRA", "JPN"))
result <- add_short_names_column(df, id_column = "country")

}
