% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecostatscale.R
\name{sd_scale}
\alias{sd_scale}
\title{Sigma scaling function}
\usage{
sd_scale(msd_b, murho_b, mucov_b = NULL, b = 1, B)
}
\arguments{
\item{msd_b}{Mean disturbance standard deviation observed at scale b.}

\item{murho_b}{Mean Pearson correlation coefficient of disturbances observed at scale b, calculated as mucov_b/mvar_b. If NULL, mucov_b is used instead.}

\item{mucov_b}{Mean covariane of disturbances observed at scale b. Ignored if mrho_b is not NULL. Defaults to NULL.}

\item{b}{Size of observed scale. Defaults to 1.}

\item{B}{Size of desired scale for extrapolation.}
}
\value{
Extrapolated disturbance standard deviation at scale B.
}
\description{
Extrapolate disturbance standard deviation observed at spatial or ecological scale b
to a different scale, B (inversely related to resistance). Equivalent to Eq.7b in the main text.
}
\examples{
#extrapolate from scale of 1 to 10 - e.g. from a 1m2 patch to a 10m2 patch
sd_scale(msd_b = 1, murho_b = 0.5, b = 1, B = 10)
}
