% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getUpdate.R
\name{getUpdate}
\alias{getUpdate}
\title{Retrieve the weight updates and their change for each learning event.}
\usage{
getUpdate(
  wmlist,
  data,
  select.outcomes = NULL,
  split = "_",
  present.outcome = FALSE
)
}
\arguments{
\item{wmlist}{A list with weightmatrices, generated by 
\code{\link{RWlearning}} or \code{\link{updateWeights}}.}

\item{data}{Data with columns \code{Cues} and \code{Outcomes},
as generated with \code{\link{createTrainingData}}.}

\item{select.outcomes}{Optional selection of outcomes to limit the number of 
activations that are returned. The value of NULL (default) will 
return all activations. Note that specified values that are not in 
the weightmatrices will return the initial value without error or warning. 
Please use  \code{\link{getValues}} for returning all outcomes in the data.}

\item{split}{String, separator between cues or outcomes.}

\item{present.outcome}{Logical: whether or not to output the update 
for the present output only. Defaults to FALSE. Note that if set to true,
this parameter cancels the effect of \code{select.outcomes}.}
}
\value{
Data frame.
}
\description{
For a given set of training data, 
the weight updating values are returned for each or specific outcomes. 
The values are returned as data frame.
}
\examples{
# load example data:
data(dat)

# add obligatory columns Cues, Outcomes, and Frequency:
dat <- droplevels(dat[1:3,])
dat$Cues <- paste("BG", dat$Shape, dat$Color, sep="_")
dat$Outcomes <- dat$Category
dat$Frequency <- dat$Frequency1
head(dat)


# now use createTrainingData to sample from the specified frequencies: 
train <- createTrainingData(dat)
head(train)

# this training data can actually be used train network:
wm <- RWlearning(train)

# retrieve update values for all outcomes:
updates1 <- getUpdate(data=train, wmlist=wm)
head(updates1)

# retrieve update values for observed outcomes:
updates2 <- getUpdate(data=train, wmlist=wm, present.outcome=TRUE)
head(updates2)

# plot:
n <- which("animal" == train$Outcomes)
plot(n, updates2[n], type='l', 
    ylim=c(0,.1), 
    ylab="Weight updates", xlab="Learning event")

}
\author{
Jacolien van Rij
}
