% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_models.R
\name{sim_model_ex2}
\alias{sim_model_ex2}
\title{Function for generating functional data in one or multiple dimension}
\usage{
sim_model_ex2(n = 50, p = 150, i_sim = 1)
}
\arguments{
\item{n}{Number of curves to generate for each of the two groups. Set to 50 by default.}

\item{p}{Number of grid points of the curves.
Curves are generated over the interval \eqn{[0, 1]}. Set to 150 grid point by default.}

\item{i_sim}{Integer set to \eqn{1, \ldots, 4}
NULL by default in which case a seed is not set.}
}
\value{
data matrix of size \eqn{2n \times p} if \eqn{i\_sim \in {1,2}}
or an array of dimensions
\eqn{2n \times p \times 2} if \eqn{i\_sim \in {3, 4}}.
}
\description{
The function can generate one-dimensional or multi-dimensional curves.
For \code{i_sim} 1 or 2, one-dimensional curves are generated.
For \code{i_sim} 3 or 4, multi-dimensional curves are generated.
}
\examples{
sm1 <- sim_model_ex2()
dim(sm1) # This should output (100, 150) by default, since n = 50 and p = 150

sm4 <- sim_model_ex2(i_sim = 4)
dim(sm4) # This should output (100, 150, 2) by default, since n = 50 and p = 150

}
