% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.r
\name{predict.eicm}
\alias{predict.eicm}
\title{Predict method for EICM fits}
\usage{
\method{predict}{eicm}(object, nrepetitions = 10000, newdata = NULL, ...)
}
\arguments{
\item{object}{the fitted EICM model.}

\item{nrepetitions}{the number of realizations to conduct for computing probabilities. Set to 1
if you only need simulated community data.}

\item{newdata}{optionally, a matrix in which to look for variables with which to predict.
If omitted, the original data (used to fit the model) is used.}

\item{...}{not used.}
}
\value{
A species x sample matrix with predictions. If nrepetitions=1, predictions correspond to one
realization, otherwise they are probabilities.
}
\description{
Obtains probability predictions (conditional or unconditional) or a model realization from a
parameterized EICM model.
}
\details{
The interaction network of the model must be an \strong{acyclic graph}.
Predictions are obtained by realizing the model multiple times and averaging realizations,
because there is not a closed-form expression for their calculation.

To obtain conditional predictions, include presence/absence columns with species names in \code{newdata}.
Named columns for all the environmental predictors must always be included.
}
\note{
If the eicm was fit without regularization, unconditional predictions are numerically equal
to those of simple binomial GLMs.
}
\examples{
# Load the included parameterized model
data(truemodel)

# for reference, plot the species interaction network
plot(truemodel, type="network")

# Unconditional predictions
# let's fix environmental predictors at 0, for simplicity.
predict(truemodel, newdata=cbind(env01=0, env02=0))

# Conditional predictions
# predict probabilities for all species conditional on the
# known presence of sp011 (compare sp014 and sp004 with the above)
predict(truemodel, newdata=cbind(env01=0, env02=0, sp011=1))

# Propagation of indirect species effects
# predict probabilities for all species conditional on the known 
# absence (first line) and known presence (second line) of sp005 and sp023
predict(truemodel, newdata=cbind(env01=0, env02=0, sp012=c(0, 1), sp018=c(0, 1)), nrep=100000)

# Notice the effects on sp026 and the effect propagation to those
# species which depend on it (sp013, sp008)
# Also compare with unconditional predictions
}
