% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigenmodel-package.R
\docType{package}
\name{eigenmodel-package}
\alias{eigenmodel-package}
\alias{eigenmodel}
\title{Semiparametric Factor and Regression Models for Symmetric Relational Data}
\description{
Estimation of the parameters in a model for symmetric relational
data (e.g., the above-diagonal part of a square matrix), using a model-based
eigenvalue decomposition and regression. Missing data is accomodated, and a
posterior mean for missing data is calculated under the assumption that the
data are missing at random. The marginal distribution of the relational data
can be arbitrary, and is fit with an ordered probit specification. See Hoff (2007) <arXiv:0711.1146> for details on the model.
}
\details{
\tabular{ll}{ Package: \tab eigenmodel\cr Type: \tab Package\cr Version:
\tab 1.11\cr Date: \tab 2019-05-28\cr License: \tab GPL Version 2 \cr }
}
\examples{


data(YX_Friend)

fit<-eigenmodel_mcmc(Y=YX_Friend$Y,X=YX_Friend$X,R=2,S=50,burn=50)

# in general you should run the Markov chain longer than 50 scans

plot(fit)


# people familiar with MCMC might want to implement 
# their own Markov chains: 

Y<-YX_Friend$Y
X<-YX_Friend$X

eigenmodel_setup(R=2)

for(s in 1:50) {   # you should run your chain longer than 50 scans

    Z<-rZ_fc() 
    UL<-rUL_fc()
    b<-rb_fc()  

                 }


#fit_Gen<-eigenmodel_mcmc(Y=Y_Gen,R=3,S=10000)

#fit_Pro<-eigenmodel_mcmc(Y=Y_Pro,R=3,S=10000)




}
\references{
Hoff (2007) ``Modeling homophily and stochastic equivalence in
symmetric relational data''
}
\author{
Peter Hoff <peter.hoff@duke.edu>
}
\keyword{package}
