% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elec_functions.R
\name{compute.stark.t}
\alias{compute.stark.t}
\title{compute.stark.t}
\usage{
compute.stark.t(
  Z,
  bound.col,
  calc.e_p = calc.pairwise.e_p,
  w_p = weight.function("no.weight"),
  err.override = NULL,
  return.revised.audit = FALSE
)
}
\arguments{
\item{Z}{If it already has an audit table with err and err.weighted then it
will use those errors, otherwise it will compute them with compute.stark.err}

\item{bound.col}{This is the vector containing the maximum number of votes
possible in the various precincts.}

\item{calc.e_p}{Function to compute e_p.  Default is calc.pairwise.e_p.}

\item{w_p}{The weight function to be applied to the precinct error.}

\item{err.override}{If non-null, use this as the found error in votes rather
than the actual errors found in the audit.}

\item{return.revised.audit}{Return the updated audit frame with the error
and weighted errors calculated.}
}
\value{
The test statistic, i.e. the maximum found error in the audit
sample, as computed by calc.e\_p and weighted by w\_p.
}
\description{
Compute the test statistic for election audits, essentially the largest
error found in the audit, as measured by the passed functions and methods.
}
\details{
This is an older method that other methods sometime use---it is probably
best ignored unless you have a good reason not to.
}
\seealso{
\code{\link{find.q}} \code{\link{stark.test}}
}
\author{
Luke W. Miratrix
}
