% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trinomial.R
\name{tri.audit.sim}
\alias{tri.audit.sim}
\title{tri.audit.sim}
\usage{
tri.audit.sim(
  Z,
  n,
  p_d = 0.1,
  swing = 5,
  return.type = c("statistics", "taints", "precinct"),
  seed = NULL,
  PID = "PID",
  ...
)
}
\arguments{
\item{Z}{elec.data object.}

\item{n}{Sample size to draw.}

\item{p_d}{The probability of a precinct having an error.}

\item{swing}{The size of the error, in votes.}

\item{return.type}{What kind of results to return: "statistics","taints", or
"precinct"}

\item{seed}{Random seed to use.}

\item{PID}{Column name of column holding unique precinct IDs}

\item{\dots}{Extra arguments passed to tri.sample}
}
\value{
List of taints found in such a circumstance OR precincts selected
with relevant attributes (including simulated errors, if asked) OR the
number of non-zero taints and the size of largest taint.
}
\description{
This is a SIMULATION FUNCTION, and is not used for actual auditing of
elections.
}
\details{
Given a matrix of votes, calculate the weights for all precincts and then
draw a sample (using tri.sample).  Then, assuming that p\_d percent of the
precincts (at random) have error, and the errors are due to vote miscounts
of size 'swing', conduct a simulated ``audit'', returning the found
descrepancies.
}
\examples{


  data(santa.cruz)
  Z = elec.data(santa.cruz, C.names=c("leopold","danner"))
  Z$V$e.max = maximumMarginBound( Z )
  ## Sample from fake truth, see how many errors we get.
  tri.audit.sim( Z, 10,  p_d=0.25, swing=10, return.type="precinct" )

  ## what does distribution look like?
  res = replicate( 200, tri.audit.sim( Z, 10,  p_d=0.25, swing=10 ) )
  apply(res,1, summary) 
  hist( res[2,], main="Distribution of maximum size taint" )

}
\seealso{
\code{\link{elec.data}} for the object that holds vote data.  See
\code{\link{tri.calc.sample}} for computing sample sizes for trinomial bound
audits.
}
\author{
Luke W. Miratrix
}
