% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_funs.R
\name{chesson_alpha}
\alias{chesson_alpha}
\alias{vs_select_coef}
\title{Chesson's alpha, or Vanderploeg and Scavia's selectivity coefficient (W)}
\usage{
chesson_alpha(r, p, na.rm = TRUE)

vs_select_coef(r, p, na.rm = TRUE)
}
\arguments{
\item{r}{(Numeric) Resource utilisation.}

\item{p}{(Numeric) Resource availability.}

\item{na.rm}{(Logical) If `TRUE`, `NA`s will be ignored when calculating the
selectivity coefficient (W).}
}
\value{
A numeric vector.
}
\description{
These two functions calculate the same value; alpha and W are identical.
}
\examples{
data(moth_distrib)

chesson_alpha(moth_distrib$r, moth_distrib$p)
vs_select_coef(moth_distrib$r, moth_distrib$p)
}
