% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo.colley.R
\name{elo.colley}
\alias{elo.colley}
\title{Compute a Colley matrix model for a matchup.}
\usage{
elo.colley(
  formula,
  data,
  family = "binomial",
  weights,
  na.action,
  subset,
  k = 1,
  ...,
  running = FALSE,
  skip = 0
)
}
\arguments{
\item{formula}{A formula. See \link[=formula.specials]{the help page for formulas} for details.}

\item{data}{A \code{data.frame} in which to look for objects in \code{formula}.}

\item{family}{Argument passed to \code{\link[stats]{glm}}.}

\item{weights}{A vector of weights. Note that these weights are used in the Colley matrix creation,
but not the regression.}

\item{na.action}{A function which indicates what should happen when the data contain NAs.}

\item{subset}{An optional vector specifying a subset of observations.}

\item{k}{The fraction of a win to be assigned to the winning team. See "details".}

\item{...}{Argument passed to \code{\link[stats]{glm}}.}

\item{running}{Logical, denoting whether to calculate "running" projected probabilities. If true, a model is fit for
group 1 on its own to predict group 2, then groups 1 and 2 to predict 3, then groups 1 through 3 to predict 4, etc.
Groups are determined in \code{formula}. Omitting a group term re-runs a glm model to predict each
observation (a potentially time-consuming operation!)}

\item{skip}{Integer, denoting how many groups to skip before fitting the running models. This is helpful if
groups are small, where glm would have trouble converging for the first few groups. The predicted values are then
set to 0.5 for the skipped groups.}
}
\description{
Compute a Colley matrix model for a matchup.
}
\details{
See the vignette for details on this method.
  The differences in assigned scores (from the coefficients of the Colley matrix regression) are fed into a logistic
  regression model to predict wins or (usually) a linear model to predict margin of victory.
  In this setting, 'k' indicates the fraction of a win to be assigned to the winning team
  (and the fraction of a loss to be assigned to the losing team); setting \code{k = 1} (the default)
  emits the "Bias Free" ranking method presented by Colley.
  It is also possible to adjust the regression by setting the second argument of
   \code{\link{adjust}()}. As in \code{\link{elo.glm}},
  the intercept represents the home-field advantage. Neutral fields can be indicated
  using the \code{\link{neutral}()} function, which sets the intercept to 0.
}
\examples{
elo.colley(score(points.Home, points.Visitor) ~ team.Home + team.Visitor, data = tournament,
  subset = points.Home != points.Visitor)
}
\references{
Colley W.N. Colley's Bias Free College Football Ranking Method: The Colley Matrix Explained. 2002.
}
\seealso{
\code{\link[stats]{glm}}, \code{\link{summary.elo.colley}}, \code{\link{score}},
  \code{\link{mov}}, \code{\link{elo.model.frame}}
}
