% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_dissimilarity_from_genetic_results}
\alias{get_dissimilarity_from_genetic_results}
\title{Recover the square matrix of distance between cocktails where the index (i,j)
of the matrix is the distance between cocktails i and j in the genetic_results
list.}
\usage{
get_dissimilarity_from_genetic_results(genetic_results, ATCtree, normalization)
}
\arguments{
\item{genetic_results}{the List returned by the genetic algorithm.}

\item{ATCtree}{: ATC tree with upper bound of the DFS (without the root)}

\item{normalization}{: Do we keep the distance between cocktail in the range [0;1] ?}
}
\value{
The square matrix of distances between cocktails
}
\description{
Recover the square matrix of distance between cocktails where the index (i,j)
of the matrix is the distance between cocktails i and j in the genetic_results
list.
}
\examples{
\donttest{
 data("ATC_Tree_UpperBound_2024")
 data("FAERS_myopathy")
 
 genetic_results = GeneticAlgorithm(epochs = 10, nbIndividuals = 10,
            ATCtree = ATC_Tree_UpperBound_2024,
            observations = FAERS_myopathy)
 distance_matrix = get_dissimilarity_from_genetic_results(genetic_results = genetic_results,
                        ATCtree = ATC_Tree_UpperBound_2024, normalization = TRUE)
}
}
