% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clustering.R
\name{hclust_genetic_solution}
\alias{hclust_genetic_solution}
\title{Clustering of the solutions of the genetic algorithm using the hclust algorithm}
\usage{
hclust_genetic_solution(
  genetic_results,
  ATCtree,
  dist.normalize = TRUE,
  method = "complete"
)
}
\arguments{
\item{genetic_results}{The return value of the genetic algorithm}

\item{ATCtree}{ATC tree with upper bound of the DFS}

\item{dist.normalize}{Do we normalize the distance (so it bellongs to [0;1])}

\item{method}{(from hclust function) the agglomeration method to be used. This should be (an unambiguous abbreviation of) one of "ward.D", "ward.D2", "single", "complete", "average" (= UPGMA), "mcquitty" (= WPGMA), "median" (= WPGMC) or "centroid" (= UPGMC).}
}
\value{
the hierarchical clustering of the results of the genetic algorithm
}
\description{
Clustering of the solutions of the genetic algorithm using the hclust algorithm
}
\examples{
\donttest{
data("ATC_Tree_UpperBound_2024")
data("FAERS_myopathy")

results = GeneticAlgorithm(epochs = 10, nbIndividuals = 10, 
            ATCtree = ATC_Tree_UpperBound_2024,
            observations = FAERS_myopathy)

hclust_genetic_solution(genetic_results = results,
                 ATCtree = ATC_Tree_UpperBound_2024)
}
}
