% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{p_value_cocktails}
\alias{p_value_cocktails}
\title{Used to add the p_value to each cocktail of cocktail list}
\usage{
p_value_cocktails(
  distribution_outputs,
  cocktails,
  ATCtree,
  observations,
  num_thread = 1L,
  filtred_distribution = FALSE
)
}
\arguments{
\item{distribution_outputs}{A list of distribution of cocktails of different sizes
in order to compute the p_value for multiple cocktail sizes}

\item{cocktails}{A list containing cocktails in the form of vector of integers (ATC index)}

\item{ATCtree}{ATC tree with upper bound of the DFS (without the root)}

\item{observations}{observation of the AE based on the medications of each patients
(a DataFrame containing the medication on the first column and the ADR (boolean) on the second)
on which we want to compute the risk distribution}

\item{num_thread}{Number of thread to run in parallel if openMP is available, 1 by default}

\item{filtred_distribution}{Does the p-values have to be computed using filtered distribution
or normal distribution (filtered distribution by default)}
}
\value{
A real valued number vector representing the p-value of the inputed
cocktails computed on the distribution_outputs List.
}
\description{
Used to add the p_value to each cocktail of cocktail list
}
\examples{
\donttest{
 data("ATC_Tree_UpperBound_2024")
 data("FAERS_myopathy")
 
  DistributionApproximationResults_size2 = DistributionApproximation(epochs = 10,
            ATCtree = ATC_Tree_UpperBound_2024, observations = FAERS_myopathy, Smax = 2)
            
  DistributionApproximationResults_size3 = DistributionApproximation(epochs = 10,
            ATCtree = ATC_Tree_UpperBound_2024, observations = FAERS_myopathy, Smax = 3)
            
  score_distribution_list = list(DistributionApproximationResults_size2,
                              DistributionApproximationResults_size3)

  cocktails = list(c(561, 904),
               c(1902, 4585))
 
  p_value_cocktails(score_distribution_list, cocktails, ATC_Tree_UpperBound_2024,
                    FAERS_myopathy)
}
}
