% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{p_value_genetic_results}
\alias{p_value_genetic_results}
\title{Used to add the p_value to each cocktail of an output of the genetic algorithm}
\usage{
p_value_genetic_results(
  distribution_outputs,
  genetic_results,
  filtred_distribution = FALSE
)
}
\arguments{
\item{distribution_outputs}{A list of distribution of cocktails of different sizes
in order to compute the p_value for multiple cocktail sizes}

\item{genetic_results}{outputs of the genetic algorithm}

\item{filtred_distribution}{Does the p-values have to be computed using filtered distribution
or normal distribution (filtered distribution by default)}
}
\value{
A real valued number vector representing the p-value of the inputed
genetic algorithm results (genetic_results) computed on the 
distribution_outputs List.
}
\description{
Used to add the p_value to each cocktail of an output of the genetic algorithm
}
\examples{
\donttest{
 data("ATC_Tree_UpperBound_2024")
 data("FAERS_myopathy")
  DistributionApproximationResults_size2 = DistributionApproximation(epochs = 10,
            ATCtree = ATC_Tree_UpperBound_2024, observations = FAERS_myopathy, Smax = 2)
            
  DistributionApproximationResults_size3 = DistributionApproximation(epochs = 10,
            ATCtree = ATC_Tree_UpperBound_2024, observations = FAERS_myopathy, Smax = 3)
            
  score_distribution_list = list(DistributionApproximationResults_size2,
                              DistributionApproximationResults_size3)
  genetic_results = GeneticAlgorithm(epochs = 10, nbIndividuals = 20, 
            ATCtree = ATC_Tree_UpperBound_2024,
            observations = FAERS_myopathy)
  p_value_genetic_results(score_distribution_list, genetic_results)
}
}
