% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hl-diff.R
\name{hl_diff}
\alias{hl_diff}
\title{Colour the differences between character representations of objects}
\usage{
hl_diff(
  x,
  y,
  coerce = "default",
  fill = NULL,
  text = NULL,
  opts = hl_opts(),
  sep = NULL,
  ...
)
}
\arguments{
\item{x, y}{each argument is a single string. vectors of strings not currently
supported.}

\item{coerce}{How should non-character arguments be coerced to character strings?
\describe{
  \item{default}{ - the given object \code{x} must already be a character string}
  \item{character}{ - performs the matching after first calling
          \code{as.character(x)}}
  \item{print}{ - performs the matching against the default
           \code{print(x)} output}
  \item{deparse}{ - performs the matching after first calling
          \code{deparse1(x)}}
  \item{str}{ - performs the matching on the output of calling
          \code{str(x)}}
}}

\item{fill}{named list of colours for substitutions, insertions and
deletions with names 'sub', 'ins' and 'del'.  If set to NULL (the
default) then default colours will be used.}

\item{text}{named list of colours for the text for 'sub', 'ins' and 'del'
operations. If \code{NULL}, then colours which contrast with \code{fill} will
be chosen automatically}

\item{opts}{create options list}

\item{sep}{character string of the  line separating the two objects. Default: \code{NULL}
for no separation. Use the empty string to insert an empty line.}

\item{...}{further arguments passed to \code{adist()}}
}
\value{
list of 'emphatic' objects which could be rendered to ANSI (for example)
}
\description{
Highlight the differences between two strings in
terms of substitutions, insertions and deletions calculated by
the generalized Levenshtein (edit) distance (using \code{adist()})
}
\details{
This works character-by-character, so the displayed difference for multiline
strings can be quite busy if there are a lot of changes.
}
\examples{
hl_diff('hello', 'there')
}
