% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epe4md_graficos.R
\encoding{UTF-8}
\name{epe4md_graf_pot_regiao}
\alias{epe4md_graf_pot_regiao}
\title{Gráfico da capacidade instalada acumulada por região}
\usage{
epe4md_graf_pot_regiao(dados, ano_inicio = 2013, tamanho = 14)
}
\arguments{
\item{dados}{data.frame. Resultados mensais de potência e energia.}

\item{ano_inicio}{numeric. Define o ano em que se inicia o eixo x. Default igual a 2013.}

\item{tamanho}{numeric. Altera tamanho da fonte da legenda. Default igual a 14.}
}
\description{
Gráfico da capacidade instalada acumulada por região.
}
\value{
Plota um gráfico da capacidade instalada acumulada por região.
}
\examples{

dados <- structure(
  list(
    data = structure(c(16587, 16953, 17348), class = "Date"),
    ano = c(2015, 2016, 2017),
    mes = c(6, 6, 7),
    nome_4md = c("EQUATORIAL PA", "AME", "AME"),
    subsistema = c("N", "MAN", "MAN"),
    uf = c("PA", "AM", "AM"),
    segmento = c("comercial_at", "comercial_at", "residencial"),
    fonte_resumo = c("Fotovoltaica", "Fotovoltaica", "Fotovoltaica"),
    energia_mwh = c(2.91887385534686, 1.47730302655558, 6.59899395709866),
    energia_autoc_mwh = c(2.33509908427749, 1.18184242124447, 2.63959758283946),
    energia_inj_mwh = c(0.583774771069372, 0.295460605311116, 3.9593963742592),
    energia_mwmed = c(Jun = 0.00405399146575953, Jun = 0.00205180975910497,
                      Jul = 0.00886961553373476),
    pot_mes_mw = c(0, 0, 0),
    adotantes_mes = c(0, 0, 0),
    p = c(0.000218228349678747, 0.000336532886429228, 0.000109941017035186),
    q = c(1, 0.677467408094237, 0.68352139010882),
    regiao = c("N", "N", "N")),
  row.names = c(NA, -3L),
  class = c("tbl_df", "tbl", "data.frame")
)

graf_pot_regiao <- epe4md_graf_pot_regiao(
  dados = dados,
  ano_inicio = 2013,
  tamanho = 14
)
}
