% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epichains.R
\name{print.epichains_summary}
\alias{print.epichains_summary}
\title{Print an \verb{<epichains_summary>} object}
\usage{
\method{print}{epichains_summary}(x, ...)
}
\arguments{
\item{x}{An \verb{<epichains_summary>} object.}

\item{...}{Not used.}
}
\value{
Invisibly returns an \verb{<epichains_summary>}. Called for
side-effects.
}
\description{
Prints a summary of the \verb{<epichains_summary>} object. In particular, it
prints the number of chains simulated, and the range of
the statistic, represented as the maximum (\code{max_stat}) and minimum
(\code{min_stat}). If the minimum or maximum is infinite, it is represented as
\verb{>= stat_threshold} where \code{stat_threshold} is the value of the censoring
limit. See \code{?epichains_summary()} for the definition of \code{stat_threshold}.
}
\examples{
# Using a Poisson offspring distribution and simulating from an infinite
# population up to chain size 10.
set.seed(32)
chain_summary_print_eg <- simulate_chain_stats(
  n_chains = 10,
  statistic = "size",
  offspring_dist = rpois,
  stat_threshold = 10,
  lambda = 2
)
chain_summary_print_eg # Print the object
}
\author{
James M. Azam
}
