% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Population_getters.R
\name{getPedigree}
\alias{getPedigree}
\title{Get population pedigree.}
\usage{
getPedigree(pop)
}
\arguments{
\item{pop}{a valid object of class \code{Population}.}
}
\value{
A \code{data.frame} containing vectors for each
individual's ID, its sire and dam IDs, and its phenotypic
components, across the pedigree.
}
\description{
Retrieve the pedigree of a \code{Population} object.
}
\details{
\code{getPedigree()} can be used to retrieve the pedigree of a
population, including the phenotypic components of all individuals
in the pedigree.
}
\examples{
\donttest{
# Construct a population with additive and epistatic effects
pop <- Population(
  popSize = 200, map = map100snp, QTL = 20,
  alleleFrequencies = runif(100),
  broadH2 = 0.9, narrowh2 = 0.6, traitVar = 40
)
pop <- addEffects(pop)
pop <- attachEpiNet(pop)

# Run the simulator
pop2 <- runSim(pop, generations = 150)

# Retrieve the population pedigree from the simulation
ped <- getPedigree(pop2)

# Re-run the simulation using the same pedigree
pop3 <- runSim(pop, ped)
}
}
\seealso{
\code{\link{runSim}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
