% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Population_getters.R
\name{getPhased}
\alias{getPhased}
\title{Get population phased genotypes.}
\usage{
getPhased(pop)
}
\arguments{
\item{pop}{a valid \code{Population} object.}
}
\value{
Returns a phased genotypes matrix.
}
\description{
Retrieves the current phased genotypes in the population.
}
\details{
\code{getPhased} retrieves the current phased genotypes in the population,
returning a single matrix with one individual per row and two
columns per SNP.
}
\examples{
# Construct a population
pop <- Population(
  popSize = 200, map = map100snp, QTL = 20,
  alleleFrequencies = runif(100),
  broadH2 = 0.9, narrowh2 = 0.6, traitVar = 40
)

# Retrieve genotypes
geno <- getPhased(pop)
}
\seealso{
\code{\link{Population}}, \code{\link{getHaplo}}, \code{\link{getGeno}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
